#!/bin/sh

. /etc/init.d/globals

HOST=$(hostname)
DATE=$(date +%Y%m%d_%H%M)
USRF="/var/tuxbox/config/tobackup.conf"
BAKF="$1/${2:-settings_${HOST}_${DATE}}.tar.gz"

TOBACKUP="\
	/var/tuxbox/config/settingsupdate.conf \
	\
	/var/tuxbox/config/neutrino.conf \
	/var/tuxbox/config/moviebrowser.conf \
	/var/tuxbox/config/radio-favorites.xml \
	/var/tuxbox/config/scan.conf \
	/var/tuxbox/config/timerd.conf \
	/var/tuxbox/config/weather-favorites.xml \
	/var/tuxbox/config/yWeb.conf \
	\
	/var/tuxbox/config/doscam.* \
	/var/tuxbox/config/oscam.* \
	/var/tuxbox/config/ncam.* \
	\
	/var/tuxbox/config/FritzCallMonitor.addr \
	/var/tuxbox/config/FritzCallMonitor.cfg \
	/var/tuxbox/config/auto-record-cleaner.* \
	/var/tuxbox/config/neutrino-mediathek.conf \
	/var/tuxbox/config/oscammon.conf \
	/var/tuxbox/config/plugins-hide.conf \
	/var/tuxbox/config/pr-auto-timer.* \
	/var/tuxbox/config/smarthomeinfo.conf \
	/var/tuxbox/config/tuxcal/ \
	/var/tuxbox/config/tuxcom/ \
	/var/tuxbox/config/tuxmail/ \
	/var/tuxbox/config/tuxtxt/tuxtxt2.conf \
	/var/tuxbox/config/tuxwetter/tuxwetter.conf \
	/var/tuxbox/config/tuxwetter/tuxwetter.mcfg \
	\
	/var/tuxbox/config/zapit/ \
	\
	/var/etc/ \
	\
	/var/bin/ \
	/var/keys/ \
	/var/root/ \
	/var/xupnpd/ \
	\
	/etc/exports \
	/etc/hostname \
	/etc/hosts \
	/etc/network/interfaces \
	/etc/passwd \
	/etc/profile.local \
	/etc/rc.local \
	/etc/resolv.conf \
	/etc/samba/smb.conf \
	/etc/wpa_supplicant.conf \
	\
	/var/tuxbox/flex/flex_usr.conf \
	\
	/var/tuxbox/control/ \
	/var/tuxbox/fonts/ \
	/var/tuxbox/icons/ \
	/var/tuxbox/locale/ \
	/var/tuxbox/luaplugins/ \
	/var/tuxbox/plugins/ \
	/var/tuxbox/httpd/ \
	/var/tuxbox/themes/ \
	/var/tuxbox/webradio/ \
	/var/tuxbox/webtv/ \
"

# add /var/log if it is a directory
if [ -d /var/log/ ]; then
	TOBACKUP="$TOBACKUP /var/log/"
fi

# add tobackup.conf and its content
if [ -e "${USRF}" ]; then
	TOBACKUP="$TOBACKUP ${USRF}"
	while read i
		do [ "${i:0:1}" = "#" ] || TOBACKUP="$TOBACKUP ${i%%#*}"
		done < $USRF
fi

SHOWINFO "backup to ${BAKF} ..."

# check existence
RES=""
for i in $TOBACKUP
	do [ -e "$i" ] && RES="$RES $i"
	done

TOBACKUP=$(echo $RES)

tar -czf "${BAKF}" $TOBACKUP 2>&1 >/dev/null

SHOWINFO "done."
