------------------------------------------
-- Neutrino Plugin 'Neutrino Mediathek' --
------------------------------------------
-- First version:	long time ago		Author: Most likely several but unknown to me; Jacek
--			Base functionality based on data from mediathek.slknet.de server
-- v 0.4 beta 1:	2020-03-26			Author: Roland Oberle
--			Added search for Titles and Themes (slow and dirty)
-- v 0.4 beta 2:	2020-04-01			Author: Roland Oberle
--			Error corrections and added download capabilities
-- v 0.4 beta 3:	2020-04-05			Author: Roland Oberle
--			Error corrections and .xml generation and background cleaning
-- v 0.4 beta 4:	2022-03-26			Author: GetAway
--			fix movieInfo window
-- v 0.4 beta 5:	2024-12-31			Author: GetAway
--			ported download m3u8 from BPanther, rework download and some fixes
-- v 0.4 beta 6:	2025-01-19			Author: GetAway
--			fix Livestreams resolutions, use url2 for audio
-- v 0.4 beta 7:	2025-05-10			Author: GetAway
--			fix mute / unmute
-- v 0.5.0:		2025-11-09			Author: tuxbox-neutrino
--			add configurable API base + env override, new docs

N = neutrino(0, 0, SCREEN.X_RES, SCREEN.Y_RES)
-- check lua api version
local req_major = 1
local req_minor = 78
if ((APIVERSION.MAJOR < req_major) or (APIVERSION.MAJOR == req_major and APIVERSION.MINOR < req_minor)) then
	N:checkVersion(req_major, req_minor)
	do return end
end

function loadLuaLib(lib, noerror)
	local status, data = pcall(require, lib)
	if noerror == true then
		if status == true then return data
		else return nil end
	end
	if status == true then return data
	else
		error('Lua library  not found: "' .. lib .. '[.so|.lua]"')
	end
end

V	= video.new()
M	= misc.new()
FH	= filehelpers.new()
C	= curl.new()
J	= loadLuaLib('json')
G	= loadLuaLib('n_gui')
H	= loadLuaLib('n_helpers')

CONF_PATH = '@N_CONFIG_DIR@'
if not CONF_PATH or CONF_PATH == '' or CONF_PATH:find('@N_CONFIG_DIR@', 1, true) then
	CONF_PATH = "/var/tuxbox/config/"
end
if DIR and DIR.CONFIGDIR then
	CONF_PATH = DIR.CONFIGDIR .. '/'
elseif DIR and DIR.NEUTRINO and DIR.NEUTRINO.CONFDIR then
	CONF_PATH = DIR.NEUTRINO.CONFDIR .. '/'
end
if string.sub(CONF_PATH, -1) ~= '/' then
	CONF_PATH = CONF_PATH .. '/'
end

pluginScriptPath = H.scriptPath() .. '/' .. H.scriptBase()
pluginTmpPath    = '/tmp/' .. H.scriptBase()
confFile         = CONF_PATH .. H.scriptBase() .. '.conf'
FH:rmdir(pluginTmpPath)
FH:mkdir(pluginTmpPath)
H.printf("[neutrino-mediathek] pluginScriptPath=%s", pluginScriptPath)
H.printf("[neutrino-mediathek] pluginTmpPath=%s", pluginTmpPath)
local env_api = os.getenv('NEUTRINO_MEDIATHEK_API')
if env_api ~= nil and env_api ~= '' then
	H.printf("[neutrino-mediathek] NEUTRINO_MEDIATHEK_API=%s", env_api)
end

-- include lua files
dofile(pluginScriptPath .. '/mt_variables.lua')
dofile(pluginScriptPath .. '/mt_functions.lua')
dofile(pluginScriptPath .. '/mt_images.lua')
dofile(pluginScriptPath .. '/mt_json_decode.lua')
dofile(pluginScriptPath .. '/mt_config.lua')
dofile(pluginScriptPath .. '/mt_parse_m3u8.lua')
dofile(pluginScriptPath .. '/mt_livestream.lua')
dofile(pluginScriptPath .. '/mt_mediathek.lua')
dofile(pluginScriptPath .. '/mt_leftMenu.lua')
dofile(pluginScriptPath .. '/mt_movieInfo.lua')
dofile(pluginScriptPath .. '/main.lua')
